function[D50,D50_choice,n_gs,gs_range] = get_D50(units)
%This function does a simple arithmatic mean calculation to find the
% average grain size from an input file.

D50_choice = 0;
D50 = 0;  %% Initialize to zero for the while loop, a positive value is needed
n_gs = 0;
gs_range = 0;

while D50_choice == 0
    
    disp(' ')
    disp(' ')
    disp('<<<<    Mean Grain Size (D50)    >>>>')
    disp(' ')
    disp('1. I know the average grain size in millimeters, and I will enter it.')
    disp('2. I have raw data of grain sizing in millimeters, and I need D50 calculated.')
    disp(' ')
    D50_choice = input('Please enter 1 or 2:  ');
    
    switch D50_choice
        case 1
            disp(' ')
            while D50 <= 0
                D50 = input('Please enter the mean grain size, D50, in millimeters:  ');
                if D50 <= 0
                    disp(' ')
                    disp('Please input a positive value.')
                end % if
            end % while
            
            %% Convert to proper units
            if units == 1
                D50 = D50/1000; % convert mm to m
            else
                D50 = D50*0.0032808399; % convert mm to ft
            end
            
        case 2
            
            %% Define the gs_range of grain size distributions
            gs_range = [8 11.3 16 22.6 32 45.3 64 90.5 128 180 256 362 512];
            n_gs = ones(1,14)*-1;
            
            %% Special case of first request            
            i = 1;
            disp(' ')
            while n_gs(i) < 0 | mod(n_gs(i),1) ~= 0
                fprintf('How many measurements of the grain size are less than %0.1f mm?',gs_range(1))
                n_gs(i) = input(' ');
                disp(' ')
                
                if n_gs(i) < 0 | mod(n_gs(i),1) ~= 0
                    disp('Please enter a positive integer.')
                end
            end            
            
            %% General request
            for i=2:length(gs_range)
                
                while n_gs(i) < 0 | mod(n_gs(i),1) ~= 0
                    fprintf('How many measurements lie in the %0.1f - %0.1f mm range?',gs_range(i-1),gs_range(i))
                    n_gs(i) = input(' ');
                    disp(' ')

                    if n_gs(i) < 0 | mod(n_gs(i),1) ~= 0
                        disp('Please enter a positive integer.')
                    end % if 
                    
                end % while
            end % for
            
            %% Special case of last request
            i = length(gs_range) + 1;
            
            while n_gs(i) < 0 | mod(n_gs(i),1) ~= 0
                fprintf('How many measurements of the grain size are greater than %0.1f mm?',gs_range(end))
                n_gs(i) = input(' ');
                disp(' ')

                if n_gs(i) < 0 | mod(n_gs(i),1) ~= 0
                    disp('Please enter a positive integer.')
                end %if

            end  %while

            %% Get the total number of measurements
            n_gs_total = sum(n_gs);
            
            %% Get the percentages
            for i=1:14
                percent_n_gs(i) = (n_gs(i)/n_gs_total)*100;
                if i == 1
                    cum_percent_n_gs(i) = percent_n_gs(i);
                else
                    cum_percent_n_gs(i) = percent_n_gs(i) + cum_percent_n_gs(i-1);
                end
            end
            
            %% Define the value of phi
            phi = -3:-0.5:-9.5;
            
            %% Call the interpolation function to interpolate at what phi
            %% the D50 grain size lies
            [phi_D50, Yo]=mminvinterp(phi,cum_percent_n_gs,50);
            
            %% Finally, get D50
            D50 = 2^-phi_D50;
            
            disp(' ')
            fprintf('** The mean grain size is %0.4f mm.',D50)
            disp(' ')
            
            %% Convert to proper units
            if units == 1
                D50 = D50/1000; % convert mm to m
            else
                D50 = D50*0.0032808399; % convert mm to ft
            end
            
        otherwise
            disp(' ')
            disp('Please enter 1 or 2.')
            D50_choice=0;
            
    end % switch   
end % while